connector BondPort//Base class 
 Real e;
 Real f;
end BondPort;

connector SignalPort//Base class 
 Real s;
end SignalPort;

class Node2//J1
 BondPort Port21;
 BondPort Port24;
 BondPort Port56;
 BondPort Port67;
equation
 Port21.f = Port24.f;
 Port24.f = Port56.f;
 Port56.f = Port67.f;
 -Port21.e-Port24.e-Port56.e+Port67.e = 0;
end Node2;

class Node3//J1
 BondPort Port26;
 BondPort Port30;
 BondPort Port33;
equation
 Port26.f = Port30.f;
 Port30.f = Port33.f;
 Port26.e-Port30.e-Port33.e = 0;
end Node3;

class Node4//GY
 BondPort Port23;
 parameter  Real 	GY = 0.031;
 BondPort Port27;
equation
 Port23.e = GY * Port27.f;
 Port27.e = GY * Port23.f;
end Node4;

class Node5//TF
 BondPort Port32;
 parameter  Real 	TF = 0.05;
 BondPort Port36;
equation
 Port32.e = TF * Port36.e;
 Port36.f = TF * Port32.f;
end Node5;

class Node6//J1
 BondPort Port1;
 BondPort Port35;
 BondPort Port39;
 BondPort Port42;
equation
 Port35.e-Port39.e-Port42.e-Port1.e = 0;
 Port35.f = Port39.f;
 Port39.f = Port42.f;
 Port42.f = Port1.f;
end Node6;

class Node7//Df
 BondPort Port41;
 SignalPort Port45;
equation
 Port41.e = 0;
 Port45.s = Port41.f;
end Node7;

class Node8//Integral
 SignalPort Port44;
 SignalPort Port48;
 Real 	Int;
equation
 Port44.s = der(Int);
 Port48.s = Int;
end Node8;

class Node9//Ds
 SignalPort Port47;
end Node9;

class Node11//R
 BondPort Port20;
 parameter  Real 	R = 8;
equation
 Port20.e = R * Port20.f;
end Node11;

class Node12//I
 BondPort Port29;
 parameter  Real 	Jm = 0.0000018;
 Real 	p;
equation
 Port29.e = der(p);
 p = Jm * Port29.f;
end Node12;

class Node13//I
 BondPort Port38;
 parameter  Real 	Jc = 0.0002;
 Real 	p;
equation
 Port38.e = der(p);
 p = Jc * Port38.f;
end Node13;

class Node50//R
 BondPort Port51;
 parameter  Real 	R = 0.0001;
equation
 Port51.e = R * Port51.f;
end Node50;

class Node54//I
 BondPort Port55;
 parameter  Real 	L = 0.001;
 Real 	p;
equation
 Port55.e = der(p);
 p = L * Port55.f;
end Node54;

class Node66//Se
 BondPort Port68;
 parameter  Real 	Se = 20;
equation
 Port68.e = Se;
end Node66;

model modele11b
Node2 j1_1;
Node3 j1_2;
Node4 kc;
Node5 reduc;
Node6 j1_5;
Node7 df_6;
Node8 integral_7;
Node9 ds_8;
Node11 R;
Node12 Jm;
Node13 Jc;
Node50 r_13;
Node54 L;
Node66 se_0;
equation
 connect(j1_5.Port1,r_13.Port51);
 connect(j1_1.Port21,R.Port20);
 connect(j1_1.Port24,kc.Port23);
 connect(kc.Port27,j1_2.Port26);
 connect(j1_2.Port30,Jm.Port29);
 connect(j1_2.Port33,reduc.Port32);
 connect(reduc.Port36,j1_5.Port35);
 connect(j1_5.Port39,Jc.Port38);
 connect(j1_5.Port42,df_6.Port41);
 connect(df_6.Port45,integral_7.Port44);
 connect(integral_7.Port48,ds_8.Port47);
 connect(j1_1.Port56,L.Port55);
 connect(se_0.Port68,j1_1.Port67);
end modele11b;
